function [T, H_rad] = radiogenic_heat_production(H_rad_surf,hr,T_0,Y_T,nt,dt_diff_T,time,DcT,rho_c,dx_T,dy_T)

    H_rad = H_rad_surf*exp( (Y_T - max(Y_T(:)) )./hr);                     % depth-dependent heat production

    % Modify the initial temperature profile:

    T = T_0;

    for it=2:10*nt

        dt    = dt_diff_T;
        time  = time + dt;

        qx    = - DcT*diff(T(:,2:end-1),1,1)/dx_T;
        qy    = - DcT*diff(T(2:end-1,:),1,2)/dy_T;
        dTdt  = diff(-qx,1,1)/dx_T +  diff(-qy,1,2)/dy_T + H_rad(2:end-1,2:end-1)/rho_c;
        T(2:end-1,2:end-1) = T(2:end-1,2:end-1) + dTdt*dt;

        T(1,  :)  = T(2,    :);
        T(end,:)  = T(end-1,:);
        
    end
    
%     % Check if the Temperature is equilibrated
%     hold on
%     plot(T_0(:,ny_T/2),Y_T(:,ny_T/2),'b')
%     plot(T(:,ny_T/2),Y_T(:,ny_T/2),'r')
%     hold off

end
